/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils.shapes;

import java.util.Locale;
import net.minecraft.class_1160;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

public enum ShapeDirection {
    NORTH,
    SOUTH,
    EAST,
    WEST,
    UP,
    DOWN,
    CAMERA,
    PLAYER;


    public static ShapeDirection fromString(String direction) {
        return switch (direction.toLowerCase(Locale.ROOT)) {
            case "north" -> NORTH;
            case "south" -> SOUTH;
            case "east" -> EAST;
            case "west" -> WEST;
            case "up" -> UP;
            case "down" -> DOWN;
            case "camera" -> CAMERA;
            case "player" -> PLAYER;
            default -> null;
        };
    }

    public static void rotatePoseStackByShapeDirection(class_4587 poseStack, ShapeDirection shapeDirection, class_4184 camera, class_243 objectPos) {
        switch (shapeDirection) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.method_22907(class_1160.field_20705.method_23214(180.0f));
                break;
            }
            case EAST: {
                poseStack.method_22907(class_1160.field_20705.method_23214(270.0f));
                break;
            }
            case WEST: {
                poseStack.method_22907(class_1160.field_20705.method_23214(90.0f));
                break;
            }
            case UP: {
                poseStack.method_22907(class_1160.field_20703.method_23214(90.0f));
                break;
            }
            case DOWN: {
                poseStack.method_22907(class_1160.field_20703.method_23214(-90.0f));
                break;
            }
            case CAMERA: {
                poseStack.method_22907(camera.method_23767());
                break;
            }
            case PLAYER: {
                class_243 vector = objectPos.method_1020(camera.method_19326());
                double x = vector.field_1352;
                double y = vector.field_1351;
                double z = vector.field_1350;
                double d = Math.sqrt(x * x + z * z);
                float rotX = (float)Math.atan2(x, z);
                float rotY = (float)Math.atan2(y, d);
                poseStack.method_22907(class_1160.field_20705.method_23626(rotX));
                poseStack.method_22907(class_1160.field_20703.method_23626(-rotY));
            }
        }
    }
}

